﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Heroes : RPGByteData
    {
        List<Hero> heroes;
        
        public Heroes(FileStream f)
        {
            load(f);
        }
        public Heroes()
        {
        }
        
        override public void load(FileStream f)
        {
            heroes = M.readDatabaseList<Hero>(f, "Heroes", "Hero", ref M.heroNames);
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<Hero>(heroes);
        }
    }
    
    class Hero : RPGDatabaseEntry
    {
        int id = 0;
        string heroName = ""; // 01
        string heroTitle = ""; // 02
        string charSet = ""; // 03
        int charIndex = 0; // 04
        bool charTransparent = false; // 05
        int initialLevel = 1; // 07
        int maxLevel = -1; // 08; default is 50 in 2000, 99 in 2003
        bool useCritChance = true; // 09
        int critChance = 30; // 0a
        string faceSet = ""; // 0f
        int faceIndex = 0; // 10
        bool twoSwordStyle = false; // 15
        bool fixedEquipment = false; // 16
        bool aiControl = false; // 17
        bool strongDefense = false; // 18
        int[][] statsForLevel; // 1f
        int expCurveBase = -1; // 29; default is 30 in 2000, 300 in 2003
        int expCurveIncrease = -1; // 2a; default is 30 in 2000, 300 in 2003
        int expCurveAdjustment = 0; // 2b
        int[] startingEquipment; // 33
        int unarmedAnimation = 1; // 38
        int classID = 0; // 39 (2003)
        int battleSpriteX = 220; // 3b (2003)
        int battleSpriteY = 120; // 3c (2003)
        int battlerAnimation = 1; // 3e (2003)
        List<HeroLearnSkill> learnSkills; // 3f
        bool skillCommandRenamed = false; // 42
        string skillCommandName = ""; // 43
        int conditionEffectLength = 0; // 47
        int[] conditionEffect; // 48
        int attributeRankLength = 0; // 49
        int[] attributeRank; // 4a
        long[] battleCommands; // 50, verbose only (2003)
        
        static string myClass = "Hero";
        Chunks chunks;
        
        public Hero(FileStream f)
        {
            load(f);
        }
        public Hero()
        {
        }
        
        public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                heroName = M.readStringDataName(f, id, ref M.heroNames, M.S_TOTRANSLATE);
            
            if (chunks.next(0x02))
                heroTitle = M.readString(f, M.S_TOTRANSLATE);
            if (chunks.next(0x03))
                charSet = M.readString(f, M.S_FILENAME);
            if (chunks.next(0x04))
                charIndex = M.readLengthMultibyte(f);
            if (chunks.next(0x05))
                charTransparent = M.readLengthBool(f);
            if (chunks.next(0x07))
                initialLevel = M.readLengthMultibyte(f);
            if (chunks.next(0x08))
                maxLevel = M.readLengthMultibyte(f);
            if (chunks.next(0x09))
                useCritChance = M.readLengthBool(f);
            if (chunks.next(0x0a))
                critChance = M.readLengthMultibyte(f);
            
            if (chunks.next(0x0f))
                faceSet = M.readString(f, M.S_FILENAME);
            if (chunks.next(0x10))
                faceIndex = M.readLengthMultibyte(f);
            
            if (chunks.next(0x15))
                twoSwordStyle = M.readLengthBool(f);
            if (chunks.next(0x16))
                fixedEquipment = M.readLengthBool(f);
            if (chunks.next(0x17))
                aiControl = M.readLengthBool(f);
            if (chunks.next(0x18))
                strongDefense = M.readLengthBool(f);
            
            if (chunks.next(0x1f))
                statsForLevel = M.readTwoByteArray2D(f, 6);
            
            if (chunks.next(0x29))
                expCurveBase = M.readLengthMultibyte(f);
            if (chunks.next(0x2a))
                expCurveIncrease = M.readLengthMultibyte(f);
            if (chunks.next(0x2b))
                expCurveAdjustment = M.readLengthMultibyte(f);
            
            if (chunks.next(0x33))
                startingEquipment = M.readTwoByteArray(f);
            
            if (chunks.next(0x38))
                unarmedAnimation = M.readLengthMultibyte(f);
            
            if (chunks.next(0x39))
                classID = M.readLengthMultibyte(f);
            if (chunks.next(0x3b))
                battleSpriteX = M.readLengthMultibyte(f);
            if (chunks.next(0x3c))
                battleSpriteY = M.readLengthMultibyte(f);
            if (chunks.next(0x3e))
                battlerAnimation = M.readLengthMultibyte(f);
            
            if (chunks.next(0x3f))
                learnSkills = M.readList<HeroLearnSkill>(f);
            
            if (chunks.next(0x42))
                skillCommandRenamed = M.readLengthBool(f);
            if (chunks.next(0x43))
                skillCommandName = M.readString(f, M.S_TOTRANSLATE);
            
            if (chunks.next(0x47))
                conditionEffectLength = M.readLengthMultibyte(f);
            if (chunks.next(0x48))
                conditionEffect = M.readByteArray(f);
            
            if (chunks.next(0x49))
                attributeRankLength = M.readLengthMultibyte(f);
            if (chunks.next(0x4a))
                attributeRank = M.readByteArray(f);
            
            if (chunks.next(0x50))
                battleCommands = M.readFourByteArray(f);
            
            M.byteCheck(f, 0x00);
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x01))
                M.writeString(heroName, M.S_TOTRANSLATE);
            if (chunks.wasNext(0x02))
                M.writeString(heroTitle, M.S_TOTRANSLATE);
            if (chunks.wasNext(0x03))
                M.writeString(charSet, M.S_FILENAME);
            if (chunks.wasNext(0x04))
                M.writeLengthMultibyte(charIndex);
            if (chunks.wasNext(0x05))
                M.writeLengthBool(charTransparent);
            if (chunks.wasNext(0x07))
                M.writeLengthMultibyte(initialLevel);
            if (chunks.wasNext(0x08))
                M.writeLengthMultibyte(maxLevel);
            if (chunks.wasNext(0x09))
                M.writeLengthBool(useCritChance);
            if (chunks.wasNext(0x0a))
                M.writeLengthMultibyte(critChance);
            
            if (chunks.wasNext(0x0f))
                M.writeString(faceSet, M.S_FILENAME);
            if (chunks.wasNext(0x10))
                M.writeLengthMultibyte(faceIndex);
            
            if (chunks.wasNext(0x15))
                M.writeLengthBool(twoSwordStyle);
            if (chunks.wasNext(0x16))
                M.writeLengthBool(fixedEquipment);
            if (chunks.wasNext(0x17))
                M.writeLengthBool(aiControl);
            if (chunks.wasNext(0x18))
                M.writeLengthBool(strongDefense);
            
            if (chunks.wasNext(0x1f))
                M.writeTwoByteArray2D(statsForLevel);
            
            if (chunks.wasNext(0x29))
                M.writeLengthMultibyte(expCurveBase);
            if (chunks.wasNext(0x2a))
                M.writeLengthMultibyte(expCurveIncrease);
            if (chunks.wasNext(0x2b))
                M.writeLengthMultibyte(expCurveAdjustment);
            
            if (chunks.wasNext(0x33))
                M.writeTwoByteArray(startingEquipment);
            
            if (chunks.wasNext(0x38))
                M.writeLengthMultibyte(unarmedAnimation);
            
            if (chunks.wasNext(0x39))
                M.writeLengthMultibyte(classID);
            if (chunks.wasNext(0x3b))
                M.writeLengthMultibyte(battleSpriteX);
            if (chunks.wasNext(0x3c))
                M.writeLengthMultibyte(battleSpriteY);
            if (chunks.wasNext(0x3e))
                M.writeLengthMultibyte(battlerAnimation);
            
            if (chunks.wasNext(0x3f))
                M.writeList<HeroLearnSkill>(learnSkills);
            
            if (chunks.wasNext(0x42))
                M.writeLengthBool(skillCommandRenamed);
            if (chunks.wasNext(0x43))
                M.writeString(skillCommandName, M.S_TOTRANSLATE);
            
            if (chunks.wasNext(0x47))
                M.writeLengthMultibyte(conditionEffectLength);
            if (chunks.wasNext(0x48))
                M.writeByteArray(conditionEffect);
            
            if (chunks.wasNext(0x49))
                M.writeLengthMultibyte(attributeRankLength);
            if (chunks.wasNext(0x4a))
                M.writeByteArray(attributeRank);
            
            if (chunks.wasNext(0x50))
                M.writeFourByteArray(battleCommands);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            bool is2003 = statsForLevel[0].Length > 50;
            
            if (heroName != "" // 01
             || heroTitle != "" // 02
             || charSet != "" // 03
             || charIndex != 0 // 04
             || charTransparent // 05
             || initialLevel != 1 // 07
             // 08 below
             || !useCritChance // 09
             || critChance != 30 // 0a
             || faceSet != "" // 0f
             || faceIndex != 0 // 10
             || twoSwordStyle // 15
             || fixedEquipment // 16
             || aiControl // 17
             || strongDefense // 18
             // 1f below
             || (!is2003 && expCurveBase != 30) // 29
             || (is2003 && expCurveBase != 300) // 29
             || (!is2003 && expCurveIncrease != 30) // 2a
             || (is2003 && expCurveIncrease != 300) // 2a
             || expCurveAdjustment != 0 // 2b
             // 33 below
             || unarmedAnimation != 1 // 38
             || classID != 0 // 39
             || battleSpriteX != 220 // 3b
             || battleSpriteY != 120 // 3c
             || battlerAnimation != 1 // 3e
             || learnSkills.Count > 0 // 3f
             || skillCommandRenamed // 42
             || skillCommandName != "") // 43
             // 47 irrelevant (length)
             // 48 below
             // 49 irrelevant (length)
             // 4a below
             // 50 below
                return false;
            
            if (maxLevel != statsForLevel[0].Length) // 08
                return false;
            
            // 1f
            int[] defaultHPMP = new int[] { 40, 43, 49, 55, 60, 66, 72, 79, 85, 92,
                                            98, 105, 112, 120, 127, 135, 143, 151, 160, 168,
                                            177, 186, 195, 205, 215, 225, 236, 247, 258, 269,
                                            281, 293, 305, 318, 331, 345, 359, 373, 388, 404,
                                            419, 436, 453, 471, 489, 508, 527, 547, 568, 600 };
            int[] defaultAtkDef = new int[] { 15, 16, 18, 19, 20, 22, 23, 25, 26, 28,
                                              30, 31, 33, 35, 37, 38, 40, 42, 44, 47,
                                              49, 51, 53, 55, 58, 60, 63, 65, 68, 71,
                                              74, 77, 80, 83, 86, 89, 93, 96, 100, 103,
                                              107, 111, 115, 119, 124, 128, 133, 138, 143, 150 };
            int[] defaultMindAgi = new int[] { 20, 22, 25, 28, 31, 34, 37, 40, 43, 46,
                                               50, 53, 57, 61, 64, 68, 72, 76, 81, 85,
                                               89, 94, 98, 103, 108, 113, 119, 124, 129, 135,
                                               141, 147, 153, 160, 166, 173, 180, 187, 194, 202,
                                               210, 218, 227, 236, 245, 254, 264, 274, 284, 300 };
            
            for (int i = 0; i < 6; i++)
            {
                for (int j = 0; j < statsForLevel[0].Length; j++)
                {
                    if (!is2003)
                    {
                        int defaultValue = (i == 0 || i == 1)? defaultHPMP[j]
                                         : (i == 2 || i == 3)? defaultAtkDef[j]
                                                             : defaultMindAgi[j];
                        if (statsForLevel[i][j] != defaultValue)
                            return false;
                    }
                    else
                    {
                        int defaultValue = i != 1? 1 : 0;
                        if (statsForLevel[i][j] != defaultValue)
                            return false;
                    }
                }
            }
            
            for (int i = 0; i < startingEquipment.Length; i++) // 33
                if (startingEquipment[i] != 0)
                    return false;
            
            for (int i = 0; i < conditionEffect.Length; i++) // 48
                if (conditionEffect[i] != 2)
                    return false;
            
            for (int i = 0; i < attributeRank.Length; i++) // 4a
                if (attributeRank[i] != 2)
                    return false;
            
            for (int i = 0; i < battleCommands.Length; i++) // 50
                if (battleCommands[i] != i)
                    return false;
            
            return true;
        }
    }
    
    class HeroLearnSkill : RPGByteData
    {
        int id = 0;
        int learnLevel = 1; // 01
        int learnID = 1; // 02
        
        static string myClass = "HeroLearnSkill";
        Chunks chunks;
        
        public HeroLearnSkill(FileStream f)
        {
            load(f);
        }
        public HeroLearnSkill()
        {
        }
        
        override public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                learnLevel = M.readLengthMultibyte(f);
            if (chunks.next(0x02))
            {
                int length = M.readByte(f);
                learnID = length == 1? M.readByte(f) : M.readTwoBytes(f);
            }
            
            M.byteCheck(f, 0x00);
        }
        
        override protected void myWrite()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x01))
                M.writeLengthMultibyte(learnLevel);
            if (chunks.wasNext(0x02))
            {
                int value = learnID;
                int length = value >= 256? 2 : 1;
                M.writeByte(length);
                    
                if (length == 1)
                    M.writeByte(value);
                else
                    M.writeTwoBytes(value);
            }
            
            M.writeByte(0x00);
        }
    }
}
